/*
 * ezlcd.c
 * by Mauro Grassi May 2007
 * Driver for ezLCD LCD module
 *
 * Connected by serial interface through DEBUG port of AT89C51SND1C
*/

//*********************************************************
//*                Header Files
//*********************************************************

#include "h/HardwareProfile.h"
#include "h/ezlcd.h"

//*********************************************************
//*               External References
//*********************************************************
extern void delayMs(int);
//*********************************************************
//*               Function Prototypes
//*********************************************************
//*********************************************************
//*               Code Implementation
//*********************************************************

void sendc_dbguart(BYTE y)
{

}

void sendc_ezlcd(BYTE ch)
{
  		int i;
		sendc_dbguart(ch);
        for(i=0;i<EZLCD_DELAY;i++)
		{
		asm("nop");
		}
}

void delayMs(int x)
{

}

void cls_ezlcd(void)
{
	sendc_ezlcd(0x21);
	delayMs(100);
}

void light_ezlcd(BYTE i)
{
	if(i==0)sendc_ezlcd(0x23); else sendc_ezlcd(0x22);
}

void writec_ezlcd(BYTE ch)
{
sendc_ezlcd(0x3C);					// ezLCD opcode for printbg
sendc_ezlcd(ch);					// send the character to print...
}

/*
 * Print byte hex
 * at location (x,y)
*/

void disa(int x, int y, int num)
{
BYTE ch;

sendc_ezlcd(0x25);				// ezLCD opcode for set cursor
sendc_ezlcd(x);
sendc_ezlcd(y);

ch=(num>>4)&0x0F;
if(ch>9)ch+=7;
ch+=0x30;
writec_ezlcd(ch);

ch=num&0x0F;
if(ch>9)ch+=7;
ch+=0x30;

writec_ezlcd(ch);
writec_ezlcd(' ');
}

void disafree(int num)
{
BYTE ch;

ch=(num>>4)&0x0F;
if(ch>9)ch+=7;
ch+=0x30;
writec_ezlcd(ch);

ch=num&0x0F;
if(ch>9)ch+=7;
ch+=0x30;
writec_ezlcd(ch);
}


void disword(int num)
{
writec_ezlcd('0');
writec_ezlcd('x');
disafree(0xFF&(num>>8));
disafree(0xFF&num);
}

void disdword(long num)
{
disafree(0xFF&(num>>24));
disafree(0xFF&(num>>16));
disafree(0xFF&(num>>8));
disafree(0xFF&num);
}

void iitoa(int num, BYTE *mystr, int radix)
{
        int i,a;
        unsigned int n,l;
	int blanking;
	BYTE buffer[8];
		
	a=0;
	n=num;
	for(i=0;i<8;i++){

         l=0xF&(n%radix);
         n=n/radix;

         if(l>9)l+=7;
	 l+=0x30;
	 buffer[a]=l; 
	 a++;
	 }	
	blanking=1;
	a=0;
	for(i=7;i>-1;i--){
		if((blanking!=1)){ mystr[a]=buffer[i]; a++; }
		if((blanking==1)&&(buffer[i]!=0x30)){ blanking=0; mystr[a]=buffer[i]; a++; }
		if((blanking==1)&&(buffer[i]==0x30)&&(i==0)){ mystr[a]=0x30; a++; }
		}
	mystr[a]=0x00;
	a++;
}


void disdec(int x, int y, int num)
{
sendc_ezlcd(0x25);
sendc_ezlcd(x);
sendc_ezlcd(y);
disdecfree(num);
}

void disdecfree(int num)
{
BYTE mystring[20];
int i;
iitoa(num,mystring,10);
i=0;
while(mystring[i]!=0){
 	writec_ezlcd(mystring[i]);
 	i++;
	}	
}

void writestring_ezlcd(BYTE *str)
{
	while((*str)!='\0')
	{
		writec_ezlcd(*str);
		str++;
	}
}

void setcolour_ezlcd(int col)
{
	sendc_ezlcd(0x24);
	sendc_ezlcd(col);
}

void setfont_ezlcd(int font)
{
	sendc_ezlcd(0x2B);
	sendc_ezlcd(font);
}

void setbgcolour_ezlcd(int col)
{
	sendc_ezlcd(0x34);
	sendc_ezlcd(col);
}

void setcursor_ezlcd(int x, int y)
{

sendc_ezlcd(0x25);
sendc_ezlcd(x);
sendc_ezlcd(y);
}


void init_ezlcd(void)
{
	TRISBbits.TRISB4=0;
	LATBbits.LATB4=1;
	delayMs(250);
	LATBbits.LATB4=0;
	delayMs(250);
	setcolour_ezlcd(0xFF);
	setbgcolour_ezlcd(0xFF);
	cls_ezlcd();
	light_ezlcd(1);
	setcolour_ezlcd(0x00);
}
